(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     36906,       1124]
NotebookOptionsPosition[     34257,       1033]
NotebookOutlinePosition[     34791,       1052]
CellTagsIndexPosition[     34748,       1049]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["02 Vector Operations", "Title",
 CellChangeTimes->{{3.544391134969587*^9, 3.5443911398658667`*^9}}],

Cell["\<\
Submit your completed work by placing this file in your folder of \
GCFile:\\Classes\\MATH213.\
\>", "Text",
 CellChangeTimes->{{3.543847682631153*^9, 3.543847690566946*^9}, {
  3.5442904675915427`*^9, 3.5442905126305428`*^9}, {3.576599489007595*^9, 
  3.5765994903973227`*^9}}],

Cell[CellGroupData[{

Cell["Computation", "Section",
 CellChangeTimes->{{3.5443911954340453`*^9, 3.544391201833411*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ".  Calculate ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    StyleBox["a",
     FontWeight->"Bold"], "||"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[CenterDot]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 ", angle between ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["proj", 
     StyleBox["b",
      FontWeight->"Bold"]], "(", 
    StyleBox["a",
     FontWeight->"Bold"], ")"}], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 ".  The first, second, and last computations are each done in two different \
ways."
}], "Text",
 CellChangeTimes->{{3.544391331030801*^9, 3.544391408961258*^9}, {
  3.544391543356945*^9, 3.5443915999081798`*^9}, {3.544391702073023*^9, 
  3.5443917213101234`*^9}, {3.5443918679255095`*^9, 3.5443918939419975`*^9}, {
  3.5443919570996103`*^9, 3.54439198629128*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 SqrtBox[
  RowBox[{"a", ".", "a"}]], "\[IndentingNewLine]", 
 RowBox[{"Norm", "[", "a", "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", ".", "b"}], "\[IndentingNewLine]", 
 RowBox[{"Dot", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ArcCos", "[", 
  FractionBox[
   RowBox[{"a", ".", "b"}], 
   RowBox[{
    RowBox[{"Norm", "[", "a", "]"}], 
    RowBox[{"Norm", "[", "b", "]"}]}]], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Projection", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", "\[Cross]", "b"}], "\[IndentingNewLine]", 
 RowBox[{"Cross", "[", 
  RowBox[{"a", ",", "b"}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5443912673101563`*^9, 3.544391272546456*^9}, {
   3.544391468546666*^9, 3.5443915327123365`*^9}, {3.5443916056495085`*^9, 
   3.5443916574254694`*^9}, {3.5443917281545153`*^9, 
   3.5443917319937344`*^9}, {3.5443917745971713`*^9, 3.544391821404849*^9}, 
   3.544391933586265*^9}],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.544391935646383*^9}}],

Cell[BoxData[
 SqrtBox["2"]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.5443919356513834`*^9}}],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.5443919356543837`*^9}}],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.5443919356583834`*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], "3"]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.5443919356613836`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.5443919356653843`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.544391935669384*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.5443919078757944`*^9, 3.5443919356733847`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Graphing", "Section",
 CellChangeTimes->{{3.5443956477557034`*^9, 3.5443956488747673`*^9}}],

Cell["\<\
Here are two functions that help my ability to visualize.  myAxis returns \
graphic primitives that create an axis in the given component direction with \
the given label in the given color from lo to hi; the axis is dashed for \
negative values.  myPoint includes dashed lines indicating how one might plot \
the point by hand and a label for the point.\
\>", "Text",
 CellChangeTimes->{{3.5443931462386246`*^9, 3.5443931949874134`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"myAxis", "[", 
    RowBox[{
    "label_", ",", "color_", ",", "component_", ",", "lo_", ",", "hi_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "g", ",", "o"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"o", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
      RowBox[{"e", "=", "o"}], ";", 
      RowBox[{
       RowBox[{
       "e", "\[LeftDoubleBracket]", "component", "\[RightDoubleBracket]"}], 
       "=", "1"}], ";", "\[IndentingNewLine]", 
      RowBox[{"g", "=", 
       RowBox[{"{", 
        RowBox[{"color", ",", 
         RowBox[{"Text", "[", 
          RowBox[{"label", ",", 
           RowBox[{"1.05", " ", "hi", " ", "e"}]}], "]"}], ",", 
         RowBox[{"Arrowheads", "[", "0.02", "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{"o", ",", 
            RowBox[{"hi", " ", "e"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"lo", "<", "0"}], ",", 
        RowBox[{"g", "=", 
         RowBox[{"Join", "[", 
          RowBox[{"g", ",", 
           RowBox[{"{", 
            RowBox[{"Dashed", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"lo", " ", "e"}], ",", "o"}], "}"}], "]"}], ",", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", "}"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
      "\[IndentingNewLine]", "g"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"myPoint", "[", 
    RowBox[{"p_", ",", "color_", ",", "label_"}], "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"color", ",", 
     RowBox[{"Text", "[", 
      RowBox[{"label", ",", 
       RowBox[{"1.1", " ", "p"}]}], "]"}], ",", "Dashed", ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"p", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}],
           ",", 
          RowBox[{"p", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}],
           ",", "0"}], "}"}], ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
     RowBox[{"Point", "[", "p", "]"}], ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", "}"}], "]"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.544260709698449*^9, 3.5442607186279593`*^9}, {
  3.54428111716831*^9, 3.5442811280423098`*^9}, {3.5442856744219174`*^9, 
  3.5442856853789177`*^9}, {3.5442900062835426`*^9, 3.544290041155543*^9}, {
  3.5443927636957445`*^9, 3.544392786886071*^9}, {3.544392851243752*^9, 
  3.5443928515137672`*^9}}],

Cell[TextData[{
 "Draw a graph of the points and vectors ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " along with part of the plane determined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 "."
}], "Text",
 CellChangeTimes->{{3.544393214601535*^9, 3.5443933354354467`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}]}], ";", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<x\>\"", ",", "Orange", ",", "1", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<y\>\"", ",", 
        RowBox[{"Darker", "[", "Yellow", "]"}], ",", "2", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myAxis", "[", 
       RowBox[{"\"\<z\>\"", ",", "Green", ",", "3", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
      RowBox[{"myPoint", "[", 
       RowBox[{
        RowBox[{"a", "\[Cross]", "b"}], ",", "Red", ",", 
        "\"\<a\[Cross]b\>\""}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "a"}], "}"}], "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", "b"}], "}"}], "]"}], ",", "Red", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{"o", ",", 
           RowBox[{"a", "\[Cross]", "b"}]}], "}"}], "]"}], ",", 
        RowBox[{"Opacity", "[", 
         RowBox[{"0.5", ",", "Blue"}], "]"}], ",", 
        RowBox[{"Polygon", "[", 
         RowBox[{"{", 
          RowBox[{"a", ",", "b", ",", 
           RowBox[{"-", "a"}], ",", 
           RowBox[{"-", "b"}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}], ",", 
    RowBox[{"ViewPoint", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.544188998883645*^9, 3.544189003768761*^9}, {
   3.5441897207364597`*^9, 3.5441897323461676`*^9}, {3.544190060055626*^9, 
   3.54419009446349*^9}, {3.5441901254087315`*^9, 3.5441901463092475`*^9}, {
   3.544190177415721*^9, 3.5441902335381937`*^9}, 3.5441902947152634`*^9, {
   3.5441904213970203`*^9, 3.5441904708429275`*^9}, {3.544191432467061*^9, 
   3.5441914326231127`*^9}, {3.544191466267708*^9, 3.544191473633315*^9}, 
   3.5441915498818345`*^9, {3.5441915858838005`*^9, 3.544191637041529*^9}, {
   3.5441952332194257`*^9, 3.5441952922172594`*^9}, {3.544227068842256*^9, 
   3.5442270705913563`*^9}, {3.544227108415519*^9, 3.544227136351117*^9}, {
   3.54422717940758*^9, 3.544227211334406*^9}, {3.544227258272091*^9, 
   3.5442272583830967`*^9}, {3.544264576475616*^9, 3.544264578367724*^9}, {
   3.544264611410614*^9, 3.5442647285733156`*^9}, {3.5442655755097575`*^9, 
   3.5442656265276756`*^9}, {3.544265668290064*^9, 3.5442656717772636`*^9}, {
   3.5442657178929014`*^9, 3.5442657435013657`*^9}, {3.5442683095971384`*^9, 
   3.544268333300494*^9}, {3.544268372027709*^9, 3.5442684125960293`*^9}, {
   3.544271170958799*^9, 3.5442711717258425`*^9}, {3.5442792389278936`*^9, 
   3.544279242872288*^9}, {3.544279277134714*^9, 3.5442792808680873`*^9}, {
   3.5442793221212125`*^9, 3.54427934140314*^9}, 3.54428111298731*^9, {
   3.544284734286769*^9, 3.544284743923805*^9}, 3.5442855942729177`*^9, {
   3.544392168068677*^9, 3.5443921821414814`*^9}, {3.544392216013419*^9, 
   3.5443922258699827`*^9}, {3.5443922779179597`*^9, 
   3.5443922786930037`*^9}, {3.5443923417416105`*^9, 3.544392424318333*^9}, {
   3.544392455639125*^9, 3.5443925750439544`*^9}, {3.5443926174083776`*^9, 
   3.5443926738816075`*^9}, {3.5443928006498585`*^9, 3.5443928242022057`*^9}, 
   3.5443935385290623`*^9}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {2.1, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {2, 0, 0}}], 
    {Dashing[{Small, Small}], Line3DBox[{{-2, 0, 0}, {0, 0, 0}}]}, 
    {RGBColor[
      NCache[
       Rational[2, 3], 0.6666666666666666], 
      NCache[
       Rational[2, 3], 0.6666666666666666], 0], Dashing[{}], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 2.1, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 2, 0}}], 
      {Dashing[{Small, Small}], Line3DBox[{{0, -2, 0}, {0, 0, 0}}]}, 
      {RGBColor[0, 1, 0], Dashing[{}], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 2.1}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 2}}], 
        {Dashing[{Small, Small}], Line3DBox[{{0, 0, -2}, {0, 0, 0}}]}, 
        {GrayLevel[0], Dashing[{}], Text3DBox[
          FormBox["\<\"a\"\>", StandardForm], {-1.1, 0., 1.1}], 
         {Dashing[{Small, Small}], 
          Line3DBox[{{-1, 0, 0}, {-1, 0, 0}, {-1, 0, 1}}], 
          {PointSize[Medium], Point3DBox[{-1, 0, 1}], 
           {GrayLevel[0], Dashing[{}], Text3DBox[
             FormBox["\<\"b\"\>", StandardForm], {1.1, 1.1, 0.}], 
            {Dashing[{Small, Small}], 
             Line3DBox[{{1, 0, 0}, {1, 1, 0}, {1, 1, 0}}], 
             {PointSize[Medium], Point3DBox[{1, 1, 0}], 
              {RGBColor[1, 0, 0], Dashing[{}], Text3DBox[
                FormBox["\<\"a\[Cross]b\"\>", StandardForm], {-1.1, 
                1.1, -1.1}], 
               {Dashing[{Small, Small}], 
                Line3DBox[{{-1, 0, 0}, {-1, 1, 0}, {-1, 1, -1}}], 
                {PointSize[Medium], Point3DBox[{-1, 1, -1}], 
                 {GrayLevel[0], Dashing[{}], 
                  Arrow3DBox[{{0, 0, 0}, {-1, 0, 1}}], 
                  Arrow3DBox[{{0, 0, 0}, {1, 1, 0}}], 
                  {RGBColor[1, 0, 0], Arrow3DBox[{{0, 0, 0}, {-1, 1, -1}}]}, 
                  {RGBColor[0, 0, 1], Opacity[0.5], 
                   Polygon3DBox[{{-1, 0, 1}, {1, 1, 0}, {1, 0, -1}, {-1, -1, 
                    0}}]}}}}}}}}}}}}}}}}},
  AutomaticImageSize->True,
  Axes->True,
  ImageSize->{374.4233164750652, 412.07418828500107`},
  ViewPoint->{15.607152176426109`, 157.53409434578117`, 70.28104950551322},
  ViewVertical->{-0.31651831267265285`, -0.1844295694181971, 
   0.9304847616522666}]], "Output",
 CellChangeTimes->{{3.5443922323063507`*^9, 3.54439224487807*^9}, 
   3.544392279882072*^9, 3.544392576939063*^9, {3.544392650004242*^9, 
   3.5443926753626924`*^9}, {3.544392825752294*^9, 3.544392855717008*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercises", "Section",
 CellChangeTimes->{{3.5443956564412003`*^9, 3.5443956579442863`*^9}}],

Cell[CellGroupData[{

Cell["Exercise 1 [3 points]", "Subsection",
 CellChangeTimes->{{3.544392010859685*^9, 3.5443920126677885`*^9}, {
  3.544394878382698*^9, 3.54439490674232*^9}}],

Cell[TextData[{
 "What geometric relationships do you observe among  ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 "?"
}], "Text",
 CellChangeTimes->{{3.5443947274160633`*^9, 3.544394776024843*^9}}],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " is perpendicular to  ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " form a right-handed system"
}], "Text",
 CellChangeTimes->{{3.5443947907496853`*^9, 3.5443948644949036`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 2 [9 points]", "Subsection",
 CellChangeTimes->{{3.544394719096587*^9, 3.54439472072068*^9}, {
  3.544394902094054*^9, 3.5443949187500067`*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"1", ",", "2", ",", "0"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["c",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"0", ",", "1", ",", "1"}], "\[RightAngleBracket]"}]}], 
   TraditionalForm]]],
 ".  Graph the parallelpiped defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  Find the volume and surface area of the parallelpiped defined by ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   StyleBox["c",
    FontWeight->"Bold"], TraditionalForm]]],
 ".  "
}], "Text",
 CellChangeTimes->{{3.54439409672499*^9, 3.544394140315483*^9}, {
  3.544394217665907*^9, 3.544394242181309*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0"}], "}"}]}], ";", 
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<x\>\"", ",", "Black", ",", "1", ",", "0", ",", "3"}], 
      "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<y\>\"", ",", "Black", ",", "2", ",", "0", ",", "4"}], 
      "]"}], ",", 
     RowBox[{"myAxis", "[", 
      RowBox[{"\"\<z\>\"", ",", "Black", ",", "3", ",", "0", ",", "2"}], 
      "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"a", ",", "Black", ",", "\"\<a\>\""}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"b", ",", "Black", ",", "\"\<b\>\""}], "]"}], ",", 
     RowBox[{"myPoint", "[", 
      RowBox[{"c", ",", "Black", ",", "\"\<c\>\""}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", 
        RowBox[{".5", ",", "Blue"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"o", ",", "a", ",", 
          RowBox[{"a", "+", "b"}], ",", "b"}], "}"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"c", ",", 
          RowBox[{"c", "+", "a"}], ",", 
          RowBox[{"c", "+", "a", "+", "b"}], ",", 
          RowBox[{"c", "+", "b"}]}], "}"}], "]"}], ",", 
       RowBox[{"Opacity", "[", 
        RowBox[{".5", ",", "Green"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"o", ",", "a", ",", 
          RowBox[{"a", "+", "c"}], ",", "c"}], "}"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"b", ",", 
          RowBox[{"b", "+", "a"}], ",", 
          RowBox[{"b", "+", "a", "+", "c"}], ",", 
          RowBox[{"b", "+", "c"}]}], "}"}], "]"}], ",", 
       RowBox[{"Opacity", "[", 
        RowBox[{".5", ",", "Red"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"o", ",", "c", ",", 
          RowBox[{"c", "+", "b"}], ",", "b"}], "}"}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"a", "+", "c"}], ",", 
          RowBox[{"a", "+", "c", "+", "b"}], ",", 
          RowBox[{"a", "+", "b"}]}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100", ",", "100"}], "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.544372052719632*^9, 3.5443720727496324`*^9}, {
   3.5443723208402486`*^9, 3.54437234805597*^9}, {3.544372415607724*^9, 
   3.5443724294401073`*^9}, {3.544372498484011*^9, 3.544372529029065*^9}, {
   3.544372609104072*^9, 3.544372629604122*^9}, {3.5443727960367637`*^9, 
   3.544372831214281*^9}, {3.544372912023361*^9, 3.544372922800439*^9}, {
   3.5443730187400317`*^9, 3.5443730284280005`*^9}, {3.5443731195091076`*^9, 
   3.544373133876544*^9}, {3.544373185369693*^9, 3.5443731866738234`*^9}, {
   3.5443747112167416`*^9, 3.5443747249006352`*^9}, 3.544377714149*^9, {
   3.5443943384058127`*^9, 3.544394385982534*^9}, {3.54439441912743*^9, 
   3.5443944250137663`*^9}, {3.5443944924456234`*^9, 3.544394503437252*^9}, 
   3.5443945430205164`*^9}],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Text3DBox[
    FormBox["\<\"x\"\>", StandardForm], {3.1500000000000004`, 0., 0.}], 
   {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {3, 0, 0}}], 
    {GrayLevel[0], Text3DBox[
      FormBox["\<\"y\"\>", StandardForm], {0., 4.2, 0.}], 
     {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 4, 0}}], 
      {GrayLevel[0], Text3DBox[
        FormBox["\<\"z\"\>", StandardForm], {0., 0., 2.1}], 
       {Arrowheads[0.02], Arrow3DBox[{{0, 0, 0}, {0, 0, 2}}], 
        {GrayLevel[0], Text3DBox[
          FormBox["\<\"a\"\>", StandardForm], {2.2, 1.1, 0.}], 
         {Dashing[{Small, Small}], 
          Line3DBox[{{2, 0, 0}, {2, 1, 0}, {2, 1, 0}}], 
          {PointSize[Medium], Point3DBox[{2, 1, 0}], 
           {GrayLevel[0], Dashing[{}], Text3DBox[
             FormBox["\<\"b\"\>", StandardForm], {1.1, 2.2, 0.}], 
            {Dashing[{Small, Small}], 
             Line3DBox[{{1, 0, 0}, {1, 2, 0}, {1, 2, 0}}], 
             {PointSize[Medium], Point3DBox[{1, 2, 0}], 
              {GrayLevel[0], Dashing[{}], Text3DBox[
                FormBox["\<\"c\"\>", StandardForm], {0., 1.1, 1.1}], 
               {Dashing[{Small, Small}], 
                Line3DBox[{{0, 0, 0}, {0, 1, 0}, {0, 1, 1}}], 
                {PointSize[Medium], Point3DBox[{0, 1, 1}], 
                 {RGBColor[0, 0, 1], Opacity[0.5], Dashing[{}], 
                  Polygon3DBox[{{0, 0, 0}, {2, 1, 0}, {3, 3, 0}, {1, 2, 0}}], 
                  Polygon3DBox[{{0, 1, 1}, {2, 2, 1}, {3, 4, 1}, {1, 3, 1}}], 
                  {RGBColor[0, 1, 0], Opacity[0.5], 
                   Polygon3DBox[{{0, 0, 0}, {2, 1, 0}, {2, 2, 1}, {0, 1, 1}}],
                    Polygon3DBox[{{1, 2, 0}, {3, 3, 0}, {3, 4, 1}, {1, 3, 
                    1}}]}, 
                  {RGBColor[1, 0, 0], Opacity[0.5], 
                   Polygon3DBox[{{0, 0, 0}, {0, 1, 1}, {1, 3, 1}, {1, 2, 0}}],
                    Polygon3DBox[{{2, 1, 0}, {2, 2, 1}, {3, 4, 1}, {3, 3, 
                    0}}]}}}}}}}}}}}}}}}}},
  AutomaticImageSize->True,
  Axes->True,
  ImageSize->{339.9983666042156, 316.0215649388898},
  ViewPoint->{50.418855700431365`, 129.22757298003975`, 103.72161477506786`},
  ViewVertical->{-0.6871773950615843, -0.39069976800065065`, 
   1.5254297845193652`}]], "Output",
 CellChangeTimes->{3.544372373280492*^9, 3.5443724310902724`*^9, 
  3.5443725310982723`*^9, 3.5443726303831997`*^9, 3.5443728317503347`*^9, 
  3.5443729235585146`*^9, 3.5443729668038387`*^9, 3.5443730351696744`*^9, 
  3.544373134388595*^9, 3.5443731879569516`*^9, 3.544374726174253*^9, 
  3.544377726558*^9, 3.5443944345213103`*^9, 3.544394505113348*^9, 
  3.5443945440365744`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "\[Cross]", "b"}], ")"}], ".", "c"}]], "Input",
 CellChangeTimes->{3.544377731865*^9}],

Cell[BoxData["3"], "Output",
 CellChangeTimes->{3.544377734302*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"a", "\[Cross]", "b"}], "]"}], "+", 
    RowBox[{"Norm", "[", 
     RowBox[{"b", "\[Cross]", "c"}], "]"}], "+", 
    RowBox[{"Norm", "[", 
     RowBox[{"c", "\[Cross]", "a"}], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.544394575242359*^9, 3.544394643510264*^9}}],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", 
    SqrtBox["6"]}], ")"}]}]], "Output",
 CellChangeTimes->{3.5443946449903483`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 3 [9 points]", "Subsection",
 CellChangeTimes->{{3.5443952255485544`*^9, 3.5443952273876595`*^9}, {
  3.544395328843463*^9, 3.5443953322276564`*^9}}],

Cell[TextData[{
 "Let ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"2", ",", "1"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["b",
     FontWeight->"Bold"], "=", 
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"4", ",", "0"}], "\[RightAngleBracket]"}]}], TraditionalForm]]],
 ".  Find (1) the vector projection of ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " onto ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and (2) the vector projection of ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 " onto ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]],
  FontWeight->"Bold"],
 ".  Graph all four vectors."
}], "Text",
 CellChangeTimes->{{3.5443952354061184`*^9, 3.5443952509410067`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"o", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pab", "=", 
   RowBox[{"Projection", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], ";", 
  RowBox[{"pba", "=", 
   RowBox[{"Projection", "[", 
    RowBox[{"b", ",", "a"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{"o", ",", "b"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<b\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"1.05", "b"}]}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{"o", ",", "a"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<a\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"1.05", "a"}]}], "]"}], ",", "Dashed", ",", "Red", ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{"o", ",", "pab"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<pab\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"1.05", "pab"}]}], "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{"o", ",", "pba"}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<pba\>\"", ",", "Bold", ",", "14"}], "]"}], ",", 
      RowBox[{"1.05", "pba"}]}], "]"}], ",", "Green", ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "pab"}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{"b", ",", "pba"}], "}"}], "]"}]}], "}"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5443683771648636`*^9, 3.5443686424323874`*^9}, {
  3.5443686730024443`*^9, 3.5443687081489587`*^9}}],

Cell[BoxData[
 GraphicsBox[{ArrowBox[{{0, 0}, {4, 0}}], InsetBox[
    StyleBox["\<\"b\"\>",
     StripOnInput->False,
     FontSize->14,
     FontWeight->Bold], {4.2, 0.}], ArrowBox[{{0, 0}, {2, 1}}], InsetBox[
    StyleBox["\<\"a\"\>",
     StripOnInput->False,
     FontSize->14,
     FontWeight->Bold], {2.1, 1.05}], 
   {RGBColor[1, 0, 0], Dashing[{Small, Small}], ArrowBox[{{0, 0}, {2, 0}}], 
    InsetBox[
     StyleBox["\<\"pab\"\>",
      StripOnInput->False,
      FontSize->14,
      FontWeight->Bold], {2.1, 0.}], 
    ArrowBox[NCache[{{0, 0}, {Rational[16, 5], Rational[8, 5]}}, {{0, 0}, {
       3.2, 1.6}}]], InsetBox[
     StyleBox["\<\"pba\"\>",
      StripOnInput->False,
      FontSize->14,
      FontWeight->Bold], {3.3600000000000003`, 1.6800000000000002`}], 
    {RGBColor[0, 1, 0], LineBox[{{2, 1}, {2, 0}}], 
     LineBox[NCache[{{4, 0}, {Rational[16, 5], Rational[8, 5]}}, {{4, 0}, {
        3.2, 1.6}}]]}}}]], "Output",
 CellChangeTimes->{{3.544368546592805*^9, 3.5443685558927345`*^9}, 
   3.54436860885503*^9, 3.5443686470008445`*^9, 3.5443687091070547`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"pab", ",", "pba"}], "}"}]], "Input",
 CellChangeTimes->{{3.5443689579199333`*^9, 3.544368966794821*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["16", "5"], ",", 
     FractionBox["8", "5"]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.5443689672348647`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 4 [3 points]", "Subsection",
 CellChangeTimes->{{3.5443956685948954`*^9, 3.5443956745372353`*^9}, {
  3.544396017485851*^9, 3.544396020045997*^9}}],

Cell[TextData[{
 "Investigate ",
 StyleBox["02DotProduct.nb",
  FontSlant->"Italic"],
 " with \[OpenCurlyDoubleQuote]show dot product\[CloseCurlyDoubleQuote] \
checked.  How is this demonstration showing the dot product?"
}], "Text",
 CellChangeTimes->{{3.5443957074411173`*^9, 3.5443958149522667`*^9}, {
  3.544395966511935*^9, 3.5443959685110493`*^9}}],

Cell["It is projecting one vector onto the other.", "Text",
 CellChangeTimes->{{3.5443958403597193`*^9, 3.544395852591419*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Exercise 5 [3 points]", "Subsection",
 CellChangeTimes->{{3.5443958573116894`*^9, 3.54439585907979*^9}, {
  3.5443960229581637`*^9, 3.5443960264303627`*^9}}],

Cell[TextData[{
 "Investigate ",
 StyleBox["02CrossProductOfVectorsInTheYZPlane.nb",
  FontSlant->"Italic"],
 " with \[OpenCurlyDoubleQuote]show dot product\[CloseCurlyDoubleQuote] \
checked.  What properties of the cross product does this demonstrate?"
}], "Text",
 CellChangeTimes->{{3.5443957074411173`*^9, 3.5443958149522667`*^9}, {
  3.544395957725433*^9, 3.544396011287496*^9}}],

Cell[TextData[{
 "(i) ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " is perpendicular to  ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", (ii) the length of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " is proportional to the lengths of ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", " ", "\[Theta]"}], TraditionalForm]]],
 ", and (iii) ",
 Cell[BoxData[
  FormBox[
   StyleBox["a",
    FontWeight->"Bold"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   StyleBox["b",
    FontWeight->"Bold"], TraditionalForm]]],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["a",
     FontWeight->"Bold"], "\[Cross]", 
    StyleBox["b",
     FontWeight->"Bold"]}], TraditionalForm]]],
 " form a right-handed system."
}], "Text",
 CellChangeTimes->{{3.544396065415592*^9, 3.544396103888793*^9}, {
  3.5443961419429693`*^9, 3.544396224981719*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{791, 670},
WindowMargins->{{-22, Automatic}, {Automatic, 68}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification:>FEPrivate`If[
  FEPrivate`Equal[FEPrivate`$VersionNumber, 6.], 1.5, 1.5 Inherited],
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 105, 1, 137, "Title"],
Cell[687, 25, 288, 6, 76, "Text"],
Cell[CellGroupData[{
Cell[1000, 35, 98, 1, 119, "Section"],
Cell[1101, 38, 1734, 67, 110, "Text"],
Cell[CellGroupData[{
Cell[2860, 109, 1232, 30, 312, "Input"],
Cell[4095, 141, 107, 2, 47, "Output"],
Cell[4205, 145, 109, 2, 47, "Output"],
Cell[4317, 149, 115, 2, 43, "Output"],
Cell[4435, 153, 115, 2, 43, "Output"],
Cell[4553, 157, 145, 3, 66, "Output"],
Cell[4701, 162, 237, 7, 65, "Output"],
Cell[4941, 171, 189, 5, 43, "Output"],
Cell[5133, 178, 191, 5, 43, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5373, 189, 97, 1, 119, "Section"],
Cell[5473, 192, 448, 7, 194, "Text"],
Cell[5924, 201, 2942, 77, 344, "Input"],
Cell[8869, 280, 734, 31, 78, "Text"],
Cell[CellGroupData[{
Cell[9628, 315, 3926, 81, 244, "Input"],
Cell[13557, 398, 2601, 49, 640, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16207, 453, 98, 1, 119, "Section"],
Cell[CellGroupData[{
Cell[16330, 458, 159, 2, 65, "Subsection"],
Cell[16492, 462, 511, 21, 78, "Text"],
Cell[17006, 485, 874, 39, 77, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17917, 529, 159, 2, 65, "Subsection"],
Cell[18079, 533, 1503, 61, 108, "Text"],
Cell[CellGroupData[{
Cell[19607, 598, 3563, 85, 319, "Input"],
Cell[23173, 685, 2663, 48, 496, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25873, 738, 142, 4, 43, "Input"],
Cell[26018, 744, 67, 1, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26122, 750, 365, 10, 43, "Input"],
Cell[26490, 762, 155, 5, 52, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26694, 773, 164, 2, 65, "Subsection"],
Cell[26861, 777, 990, 38, 107, "Text"],
Cell[CellGroupData[{
Cell[27876, 819, 2082, 60, 269, "Input"],
Cell[29961, 881, 1085, 26, 251, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31083, 912, 144, 3, 43, "Input"],
Cell[31230, 917, 264, 9, 66, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31543, 932, 162, 2, 65, "Subsection"],
Cell[31708, 936, 354, 8, 76, "Text"],
Cell[32065, 946, 127, 1, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32229, 952, 163, 2, 65, "Subsection"],
Cell[32395, 956, 384, 8, 105, "Text"],
Cell[32782, 966, 1435, 62, 107, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
